;==========================================================================
;Version history:
;==========================================================================
;2010/01/14     First edition
;2010/07/26     Add new declarations for speech event of SW_ChA/SW_ChB
;               Remove the interrupt mode of NMI on SW_ChA
;2011/01/20     Add new APIs for speech event, %IsEventChA, %ClrEvtFlagChA, %IsEventChB and %ClrEvtFlagChB
;2011/03/30     Add new functions "ChA_IOEvt" and "ChB_IOEvt" for declaring IO event on SW_ChA/SW_ChB
;==========================================================================
;ChA Definition
;==========================================================================
ChA_Evt:                .EQU    OFF             ;Declare the function of speech event on SW_ChA
ChA_IOEvt:              .EQU    OFF             ;Declare IO Event on SW_ChA (ChA_Evt must be ON before ChA_IOEvt is enabled)
D_ChA_RampStep:         .EQU    0CH             ;The difference for each step when ramp-up/down
D_ChA_DAC_Ctrl:         .EQU    D_DAC1_Upsampling       ;Used for initializing ChA control port

        .IF SW_ChA = ON
            .IF ChA_Evt = ON
        .PAGE0
R_ChA_EvtAddrL:         .DS     3               ;Used for speech event
R_ChA_EvtAddrH:         .EQU    R_ChA_EvtAddrL+1
R_ChA_EvtAddrB:         .EQU    R_ChA_EvtAddrL+2

        .DATA
R_ChA_EvtTag:           .DS     1               ;Event tag of a speech event
R_ChA_MainIndex:        .DS     1               ;Main index of a speech event
R_ChA_SubIndex:         .DS     1               ;Sub index of a speech event
R_ChA_EvtNumber         .DS     1               ;Event number while processing events
            .ENDIF
        .ENDIF
;==========================================================================
;ChB Definition
;==========================================================================
ChB_Evt:                .EQU    OFF             ;Declare the function of speech event on SW_ChB
ChB_IOEvt:              .EQU    OFF             ;Declare IO Event on SW_ChB (ChB_Evt must be ON before ChB_IOEvt is enabled)
D_ChB_RampStep:         .EQU    0CH             ;The difference for each step when ramp-up/down
D_ChB_DAC_Ctrl:         .EQU    D_DAC2_Upsampling       ;Used for initializing ChB control port

        .IF SW_ChB = ON
            .IF ChB_Evt = ON
        .PAGE0
R_ChB_EvtAddrL:         .DS     3               ;Used for speech event
R_ChB_EvtAddrH:         .EQU    R_ChB_EvtAddrL+1
R_ChB_EvtAddrB:         .EQU    R_ChB_EvtAddrL+2

        .DATA
R_ChB_EvtTag:           .DS     1               ;Event tag of a speech event
R_ChB_MainIndex:        .DS     1               ;Main index of a speech event
R_ChB_SubIndex:         .DS     1               ;Sub index of a speech event
R_ChB_EvtNumber         .DS     1               ;Event number while processing events
            .ENDIF
        .ENDIF
;==========================================================================
%LoadSChSpeechFreq:     .MACRO  SR
        .DW     1000H-(CPU_Clock/SR)            ;Timer Source = Fcpu
                        .ENDM
;==========================================================================
;Purpose: Initialize the status of SW_ChA
;Input: None
;Return: None
;Destroy: A
;==========================================================================
        .IF SW_ChA = ON
%ChAInitial:    .MACRO
        LDA     #D_ChA_DAC_Ctrl
        STA     P_DAC1_Ctrl
                .ENDM
;==========================================================================
;Purpose: Pause the speech on SW_ChA
;Input: None
;Return: None
;Destroy: A
;==========================================================================
%PauseChA:      .MACRO
        JSR     F_ChA_Pause
                .ENDM
;==========================================================================
;Purpose: Mute the speech on SW_ChA
;Input: None
;Return: None
;Destroy: A
;==========================================================================
%MuteChA:       .MACRO
        JSR     F_ChA_Mute
                .ENDM
;==========================================================================
;Purpose: Resume the speech which is paused by "%PauseChA" on SW_ChA
;Input: None
;Return: None
;Destroy: A
;==========================================================================
%ResumeChA:     .MACRO
        JSR     F_ChA_Resume
                .ENDM
;==========================================================================
;Purpose: Un-mute the speech which is muted by "%MuteChA" on SW_ChA
;Input: None
;Return: None
;Destroy: A
;==========================================================================
%UnMuteChA:     .MACRO
        JSR     F_ChA_UnMute
                .ENDM
;==========================================================================
;Purpose: Stop the speech on SW_ChA
;Input: None
;Return: None
;Destroy: A
;==========================================================================
%StopChA:       .MACRO
        JSR     F_ChA_Stop
                .ENDM
;==========================================================================
;Purpose: Check if the SW_ChA is active
;Input: None
;Return: C = 0, inactive; C = 1, active
;Destroy: A
;==========================================================================
%IsActiveChA:   .MACRO
        JSR     F_ChA_IsActive
                .ENDM
;==========================================================================
;Purpose: Check if the SW_ChA is paused
;Input: None
;Return: C = 0, not paused; C = 1, paused
;Destroy: A
;==========================================================================
%IsPauseChA:    .MACRO
        JSR     F_ChA_IsPause
                .ENDM
;==========================================================================
;Purpose: Check if the SW_ChA is muted
;Input: None
;Return: C = 0, not muted; C = 1, muted
;Destroy: A
;==========================================================================
%IsMuteChA:     .MACRO
        JSR     F_ChA_IsMute
                .ENDM
;==========================================================================
;Purpose: Check if any event is detected
;Input: None
;Return: C = 0, no event; C = 1, an event
;Destroy: A
;==========================================================================
%IsEventChA:    .MACRO
        JSR     F_ChA_IsEvent
                .ENDM
;==========================================================================
;Purpose: Clear event flag to allow a new event issuing
;Input: None
;Return: A = Event tag
;Destroy: A
;==========================================================================
%ClrEvtFlagChA: .MACRO
        JSR     F_ChA_ClearEvtFlag
                .ENDM
        .ENDIF
;==========================================================================
;Purpose: Initialize the status of SW_ChB
;Input: None
;Return: None
;Destroy: A
;==========================================================================
        .IF SW_ChB = ON
%ChBInitial:    .MACRO
        LDA     #D_ChB_DAC_Ctrl
        STA     P_DAC2_Ctrl
                .ENDM
;==========================================================================
;Purpose: Pause the speech on SW_ChB
;Input: None
;Return: None
;Destroy: A
;==========================================================================
%PauseChB:      .MACRO
        JSR     F_ChB_Pause
                .ENDM
;==========================================================================
;Purpose: Mute the speech on SW_ChB
;Input: None
;Return: None
;Destroy: A
;==========================================================================
%MuteChB:       .MACRO
        JSR     F_ChB_Mute
                .ENDM
;==========================================================================
;Purpose: Resume the speech which is paused by "%PauseChB" on SW_ChB
;Input: None
;Return: None
;Destroy: A
;==========================================================================
%ResumeChB:     .MACRO
        JSR     F_ChB_Resume
                .ENDM
;==========================================================================
;Purpose: Un-mute the speech which is muted by "%MuteChB" on SW_ChB
;Input: None
;Return: None
;Destroy: A
;==========================================================================
%UnMuteChB:     .MACRO
        JSR     F_ChB_UnMute
                .ENDM
;==========================================================================
;Purpose: Stop the speech on SW_ChB
;Input: None
;Return: None
;Destroy: A
;==========================================================================
%StopChB:       .MACRO
        JSR     F_ChB_Stop
                .ENDM
;==========================================================================
;Purpose: Check if the SW_ChB is active
;Input: None
;Return: C = 0, inactive; C = 1, active
;Destroy: A
;==========================================================================
%IsActiveChB:   .MACRO
        JSR     F_ChB_IsActive
                .ENDM
;==========================================================================
;Purpose: Check if the SW_ChB is paused
;Input: None
;Return: C = 0, not paused; C = 1, paused
;Destroy: A
;==========================================================================
%IsPauseChB:    .MACRO
        JSR     F_ChB_IsPause
                .ENDM
;==========================================================================
;Purpose: Check if the SW_ChB is muted
;Input: None
;Return: C = 0, not muted; C = 1, muted
;Destroy: A
;==========================================================================
%IsMuteChB:     .MACRO
        JSR     F_ChB_IsMute
                .ENDM
;==========================================================================
;Purpose: Check if any event is detected
;Input: None
;Return: C = 0, no event; C = 1, an event
;Destroy: A
;==========================================================================
%IsEventChB:    .MACRO
        JSR     F_ChB_IsEvent
                .ENDM
;==========================================================================
;Purpose: Clear event flag to allow a new event issuing
;Input: None
;Return: A = Event tag
;Destroy: A
;==========================================================================
%ClrEvtFlagChB: .MACRO
        JSR     F_ChB_ClearEvtFlag
                .ENDM
        .ENDIF
;==========================================================================
